/*
 * Decompiled with CFR 0.152.
 */
package com.resource;

import com.Application;
import com.dao.CustomerDao;
import com.utility.ConvertStr;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
public class Customer {
    private final CustomerDao customer;
    private final Application application;

    public Customer(CustomerDao customer, Application application) {
        this.customer = customer;
        this.application = application;
    }

    @ApiIgnore
    @GetMapping(value={"/CustomerExists"})
    public ResponseEntity<?> customerExists(HttpServletRequest request) {
        return this.customer.customerExists(request);
    }

    @GetMapping(value={"/Customer"})
    public ResponseEntity<?> getCustomer(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.customer.getCustomerList(request, -1, -1);
    }

    @GetMapping(value={"/Customer/{page}/{itemsPerPage}"})
    public ResponseEntity<?> getCustomer(HttpServletRequest request, @PathVariable(value="page") int page, @PathVariable(value="itemsPerPage") int itemsPerPage) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.customer.getCustomerList(request, itemsPerPage, page);
    }

    @GetMapping(value={"/Customer/count"})
    public ResponseEntity<?> getCustomerCount() {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.customer.getCustomerCount();
    }

    @GetMapping(value={"/Customer/address"})
    public ResponseEntity<?> getCustomerAddress(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.customer.getCustomerAddress(request);
    }

    @PostMapping(value={"/Customer"}, consumes={"application/json"})
    public ResponseEntity<?> postCustomer(@RequestBody String body, @RequestParam(value="allowDuplicateEco", required=false, defaultValue="false") boolean allowDuplicateEco, @RequestParam(value="allowDuplicateNatCode", required=false, defaultValue="false") boolean allowDuplicateNatCode, @RequestParam(value="allowDuplicateMobile", required=false, defaultValue="false") boolean allowDuplicateMobile) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.customer.postCustomerList(CustomerDao.CustomerPostOptions.builder().body(body).allowDuplicateEcoCode(allowDuplicateEco).allowDuplicateNatCode(allowDuplicateNatCode).allowDuplicateCell(allowDuplicateMobile).build());
    }

    @PutMapping(value={"/Customer"}, consumes={"application/json"})
    public ResponseEntity<?> putCustomer(@RequestBody String body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.customer.postCustomerList(CustomerDao.CustomerPostOptions.builder().body(body).isUpdate(true).build());
    }

    @DeleteMapping(value={"/Customer"})
    public ResponseEntity<?> deleteCustomer(@RequestParam(value="erpCode") String[] params) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.customer.deleteCustomer(params);
    }

    @PostMapping(value={"/CustomerZ"}, consumes={"application/json"})
    public ResponseEntity<?> postCustomer(@RequestBody byte[] body) {
        if (!Application.isAccessWebService || !this.application.usePack2) {
            return null;
        }
        return this.customer.postCustomerList(CustomerDao.CustomerPostOptions.builder().body(ConvertStr.deCompressionGZip((byte[])body)).rebuildJson(false).build());
    }
}

